﻿---
session_code: "BRK100"
title: "Best practices to modernize your apps and databases at scale"
date: "2025-11-19"
speakers:
  - "Marc Gunter"
  - "Mike Hulme"
  - "Amit Shah"
  - "John Yokim"

products:
  - "Microsoft Ignite"

---

# Best practices to modernize your apps and databases at scale
**Modernization and Innovation in IT Environments: Key Takeaways**

1. **Agentive Agents**: This term refers to autonomous systems that can act on their own, potentially inspired by AI technologies like ChatGPT. These agents could automate tasks, manage workflows, and operate without constant human intervention.

2. **Legacy System Modernization**: The focus was on migrating and modernizing legacy systems to the cloud using Azure. Mercedes-Benz's example highlighted successful refactoring, which involved breaking down applications into microservices for scalability and modularity.

3. **AI Tools in Development**: GitHub Copilot and similar tools were mentioned, suggesting that AI can enhance development by automating tasks and improving code quality, fostering a more efficient relationship between IT and development teams.

4. **Monitoring and Observability**: Tools like Azure Monitor and PostgresSQL were emphasized for their role in maintaining performance and security post-migration. Effective monitoring is crucial for system health and adaptability.

5. **Cost Efficiency**: The presentation underscored cost savings through standardized cloud practices, resource consolidation, and managed services, which reduce maintenance and optimize usage via scaling and automation.

6. **Azure Accelerate**: This initiative by Microsoft provides expert guidance and resources to assist organizations in their digital transformation journey, focusing on overcoming challenges beyond just technology implementation.

7. **Challenges and Considerations**: While success stories like Mercedes-Benz were showcased, potential challenges such as resistance from legacy system teams and data migration issues were implied but not detailed.

8. **Future of IT Operations**: The concept of Agentive Agents suggests a future where IT operations are more autonomous, potentially improving efficiency and reducing human error.

In summary, the presentation highlighted the strategic importance of modernizing legacy systems with cost-effective cloud solutions, leveraging AI for development enhancement, and ensuring robust monitoring strategies. The role of initiatives like Azure Accelerate in facilitating this transformation was also stressed, along with the promise of future automation in IT operations through Agentive Agents. Further exploration into these concepts and tools would be beneficial for anyone looking to modernize their IT environment.
