﻿---
session_code: "BRK104"
title: "From VMs and containers to AI apps with Azure Red Hat OpenShift"
date: "2025-11-20"
speakers:
  - "Phelipi Dal’Olio Santos"
  - "Mayuri Gupta"
  - "Campbell Vertesi"

products:
  - "Microsoft Ignite"

---

# From VMs and containers to AI apps with Azure Red Hat OpenShift
The transformation at Braesco under Mayori’s leadership was a strategic journey marked by several key elements:

1. **Foundational Infrastructure**: Establishing a robust technical foundation with Microsoft Arrow was pivotal. This allowed Braesco to transition from zero AI initiatives to over 200 in just two years.

2. **Governance and Structure**: Implementing strong governance practices ensured that AI development, deployment, and monitoring were organized and consistent. This prevented fragmentation and enabled efficient scaling.

3. **Standardization**: Creating a standardized framework for AI development facilitated quick and reliable model creation, reducing redundancy and saving resources.

4. **Virtualization Strategy**: Utilizing Azure Red Hat OpenShift for workload consolidation reduced infrastructure costs and improved efficiency through containerized applications.

5. **Incremental Approach**: Starting with small proof-of-concept projects allowed the team to test and refine their approach before scaling up, minimizing risk and maximizing learning.

6. **Partnership and Resources**: Leveraging Microsoft’s Azure Migration and Modernization program provided structured support, aiding in planning and execution without excessive upfront investment.

7. **Continuous Innovation**: The focus on innovation allowed Braesco to become a market leader in AI within Brazil, setting a benchmark for others to follow.

8. **Adaptation and Scalability**: While specific challenges like data privacy weren’t detailed, it’s evident that the foundation and governance would have addressed such issues. Scaling involved automation and integration with tools like Azure Machine Learning, enhancing overall efficiency.

In summary, Braesco’s success hinged on building a solid base, maintaining rigorous governance, standardizing processes, and effectively utilizing technology to scale AI initiatives efficiently.
