﻿---
session_code: "BRK118"
title: "The future of integration is here and it's agentic"
date: "2025-11-21"
speakers:
  - "Pratik Shinde"
  - "Eric Summers"
  - "Divya Swarnkar"
  - "Kent Weare"

products:
  - "Microsoft Ignite"

---

# The future of integration is here and it's agentic
**Microsoft Logic Apps and Agentic Capabilities: A Comprehensive Overview**

Microsoft has introduced a transformative approach to automating workflows through its Logic Apps and agent capabilities, offering a blend of AI, integration, and security. Here's a structured summary of the key points and implications:

1. **Agent Loop: Enhancing Automation with AI**
   - **Functionality**: Agent Loop empowers agents to perform beyond set rules by leveraging AI for learning and decision-making. This allows agents to understand context, adapt to user intent, and execute tasks autonomously.
   - **Example**: Demonstrated the ability of an agent to automate IT service requests through ServiceNow, reducing manual work and enhancing efficiency.

2. **Integration with Cognitive Services (MCP Servers)**
   - **Functionality**: MCP servers provide access to cognitive services like natural language processing and vision recognition, enabling agents to perform complex tasks.
   - **Implementation**: Predefined paths for legacy systems allow seamless connection without rewriting code, facilitating easier integration into existing workflows.

3. **Foundry Control Planes: Managing AI Models**
   - **Functionality**: Foundry Control Planes manage the deployment and scaling of AI models, enhancing scalability and efficiency in production environments.

4. **Security and Authentication (OBO Methods)**
   - **Functionality**: Secure access through Microsoft Entra and Octa identity providers ensures compliance and data protection, crucial for enterprise use.

5. **Deployment Flexibility**
   - **Options**: Agents can be deployed via Foundry, own models (local or VNet), or integrated into Teams/A2A ecosystems, offering flexibility tailored to organizational needs.

6. **Knowledge Retrieval and Decision-Making**
   - **Functionality**: Agents like Alisa utilize context-aware knowledge retrieval, enhancing their ability to understand user intent and provide relevant responses.

7. **Training and Management of AI Models**
   - **Tools**: Foundry likely offers tools for training and deploying models, crucial for maintaining performance over time.

8. **Considerations and Future Directions**
   - **Complexity and Limitations**: Potential need for handling large datasets, multiple languages, and complex tasks.
   - **Integration with Teams**: Agents can be part of bots or embedded in applications, enhancing accessibility.

9. **Public Preview Features and Training Opportunities**
   - **Designer Tool**: A streamlined tool simplifies building agents, making AI adoption more accessible.
   - **Labs and Hands-On Experience**: Available labs provide valuable experience with Agent Loop in ServiceNow ITSM and other use cases.

**Conclusion:**
Microsoft's approach offers a robust framework for building intelligent applications through agent capabilities in Logic Apps. The integration of AI, secure access, and various services provides a powerful solution for enhancing workflows without significant overhauls. Organizations can leverage this to automate tasks, integrate legacy systems, and implement intelligent solutions securely.
