﻿---
session_code: "BRK120"
title: "Scaling Kubernetes securely and reliably with AKS"
date: "2025-11-20"
speakers:
  - "Brendan Burns"
  - "Jorge Palma"
  - "Durga Rachapudi"

products:
  - "Microsoft Ignite"

---

# Scaling Kubernetes securely and reliably with AKS
The Azure Kubernetes Service (AKS) has been updated with several features aimed at enhancing security, scalability, and cost-efficiency. Here's a breakdown of the key updates:

1. **Managed Identities and Credentials:**
   - AKS now integrates with Azure Active Directory (Azure AD) to manage identities, providing secure access control across clusters without shared credentials.
   - Each cluster gets a dedicated credential, enhancing security by preventing cross-cluster credential misuse.

2. **Multi-Tenant Logging:**
   - Azure Monitor's container logs now support multi-tenant access through managed namespaces, allowing development teams to view only their respective logs, improving resource management and separation of concerns.

3. **Pod Sandboxing:**
   - A new feature isolates pods using a dedicated utility VM, ensuring security by separating them from other pods and the node. This is achieved with just one line change in YAML files.

4. **Cost Management Enhancements:**
   - A configurable pod scheduler uses aggressive bin packing to optimize resource utilization, reducing costs.
   - The pricing calculator provides accurate cost estimates, helping users make informed decisions without manual calculations.
   - Monitoring tools like Azure Monitor and Retina allow for tailored metric selection and log filtering, enhancing cost optimization.

5. **Security Features:**
   - Node resource group lockdown prevents accidental modifications to critical resources.
   - Network policies enforce traffic rules, contributing to a stronger security posture.

6. **Fleet Targeting:**
   - Workloads can be deployed in regions based on cost, optimizing expenses while maintaining performance.

These updates collectively enhance AKS's capabilities, making it more secure, user-friendly, and cost-efficient for various cloud environments.
