﻿---
session_code: "BRK127"
title: "Azure HorizonDB: Deep Dive into a New Enterprise-Scale PostgreSQL"
date: "2025-11-19"
speakers:
  - "Adam Prout"
  - "Denzil Ribeiro"

products:
  - "Microsoft Ignite"

---

# Azure HorizonDB: Deep Dive into a New Enterprise-Scale PostgreSQL
**Microsoft Azure Cognitive Services Integration with Horizon DB: A Comprehensive Overview**

**Introduction and Context:**
Microsoft's Horizon DB is being enhanced by integrating various Azure Cognitive Services, such as Text Analytics, Computer Vision, and Translator. These services leverage AI to perform tasks like text analysis, image recognition, and language translation, making them integral components of Horizon DB.

**Service Improvements:**
- **Enhancements:** The cognitive services have seen improvements in speed and accuracy due to increased data processing capabilities and better model training.
- **Integration Focus:** These services are now seamlessly integrated into Horizon DB, allowing AI tasks to be executed directly within the database, which simplifies development and deployment processes.

**Key Features and Capabilities:**

1. **Vector Search with DiskNN:**
   - Utilizes DiskNN for efficient vector search, enhancing performance and reducing memory usage by compressing vectors.
   - Advanced filtering improves query efficiency by combining vector search with other predicates, achieving faster results compared to traditional methods like HNSW.

2. **AI Model Management:**
   - Simplifies AI model deployment with pre-built models such as embeddings for text and images.
   - Provides a centralized management system with integrated monitoring, billing, and cost management, reducing operational complexity.

3. **Embedding Operators in SQL:**
   - Enables direct interaction with AI models through SQL statements, allowing developers to create embeddings from stored data and apply AI operations without leaving the database environment.
   - Pre-built models offer functionalities like text rewriting, entity extraction, and semantic ranking, enhancing application intelligence.

**Impact on Developers and Applications:**
- **Enhanced Productivity:** Streamlines AI integration, reducing the need for custom code and enabling seamless AI interactions through SQL.
- **Scalability and Efficiency:** Optimized for handling large data volumes with minimized overhead, ensuring efficient query processing.

**Conclusion and Future Directions:**
Horizon DB's integration of Azure Cognitive Services positions it as a powerful tool for intelligent applications. The focus is on simplifying AI deployment and management while maintaining performance and scalability. Attendees are encouraged to explore the preview version to provide feedback, which will help further refine these features.
