﻿---
session_code: "BRK132"
title: "Move fast, save more with MongoDB-compatible workloads on DocumentDB"
date: "2025-11-19"
speakers:
  - "Patty Chow"
  - "Khelan Modi"
  - "Gurvinder Singh"

products:
  - "Microsoft Ignite"

---

# Move fast, save more with MongoDB-compatible workloads on DocumentDB
**Comparison of Azure Document DB and Azure AI Search**

1. **Azure Document DB:**
   - **Primary Function:** A database service designed for storing documents and enabling efficient querying, structured around JSON documents.
   - **Vector Search Capabilities:** Utilizes KS-RPM (Knowledge Store with Retrieval Probabilistic Modelling) for advanced search capabilities, allowing complex queries on large datasets.

2. **Azure AI Search:**
   - **Primary Function:** A service optimized for searching unstructured text across various document types (Excel, PDFs, etc.) without storing data in a structured database.
   - **Use Case:** Ideal for scenarios where quick information retrieval from multiple sources is needed, such as searching through a corpus of documents.

**Key Differentiators:**
- **Data Storage and Structure:** Document DB stores data in a structured manner (JSON), suitable for applications requiring both storage and complex querying. AI Search, while efficient, does not store data but instead processes it on the fly.
- **Complementary Usage:** Both services can coexist within an application, with Document DB handling structured data storage and AI Search managing unstructured text search across various sources.

**When to Use Each:**
- **Use Azure Document DB if:** You need a database solution that stores documents (like customer data or structured records) and requires efficient querying.
- **Use Azure AI Search if:** You prioritize fast, full-text search across multiple document types without the need for storing structured data.

In summary, both services complement each other, offering flexibility in handling different types of data and search needs within an application.
