﻿---
session_code: "BRK133"
title: "How Sitecore built a scalable, isolated SaaS platform on Azure"
date: "2025-11-19"
speakers:
  - "Deborah Chen"
  - "Jeffrey Ilse"
  - "Andrew Liu"

products:
  - "Microsoft Ignite"

---

# How Sitecore built a scalable, isolated SaaS platform on Azure
To build a multi-tenant application using Azure, follow this structured approach:

### 1. **Tenant Management and Isolation**
   - **Use Azure Management Groups:** Organize your Azure resources into hierarchical structures under different tenants. This allows for better governance and management of each tenant's resources.
   - **Resource Separation:** Ensure that each tenant's resources are isolated. Use naming conventions or tags to differentiate them, and apply RBAC to restrict access to specific resources.

### 2. **Rate Limiting Implementation**
   - **Azure API Management (APIM):** Implement rate limiting policies in APIM to control request volumes per tenant. This helps prevent abuse and ensures fair usage across tenants.
   - **Request Units:** Utilize services like Azure Cosmos DB, which provide built-in request units as a rate limiter. This can be combined with APIM policies for a multi-layered approach.

### 3. **CI/CD Pipelines**
   - **Azure DevOps:** Set up CI/CD pipelines to automate builds and deployments. Use YAML files for pipeline definitions, integrating with your application's codebase.
   - **Infrastructure Orchestration:** For complex infrastructure changes, use Azure Automation Runbooks or Logic Apps to automate tasks, ensuring seamless integration with your CI/CD workflow.

### 4. **Infrastructure as Code (IaC)**
   - **Automate Infrastructure:** Use tools like Terraform or Azure-native IaC solutions to manage infrastructure resources. This allows for reproducible and scalable deployments.
   - **Orchestration Services:** Leverage services like Kubernetes (Azure Kubernetes Service) for containerized applications, ensuring that you can scale up or down resources dynamically based on tenant needs.

### 5. **Monitoring and Observability**
   - **Application Insights:** Monitor application performance and usage across tenants using Azure Application Insights. This provides insights into metrics and helps in identifying issues quickly.
   - **Centralized Logging:** Implement centralized logging to track activities across all tenants, ensuring that you can audit and troubleshoot effectively.

### 6. **Security Measures**
   - **Tenant Data Isolation:** Ensure that each tenant's data is isolated both horizontally and vertically. Use tenant IDs in URLs or query parameters and ensure that no cross-tenant data exposure occurs.
   - **Secure Configurations:** Use secure configurations (e.g., Key Vault) to store sensitive information, ensuring it's accessible only by specific tenants and within the correct scope.

### 7. **Tenant Migrations and Scaling**
   - **Automatic Scaling:** Use Azure services like Kubernetes to automatically scale resources based on load. This ensures that your application can handle spikes in usage without performance degradation.
   - **Resource Expansion:** Implement mechanisms to spin up additional resources (e.g., virtual machines or containers) for tenants requiring more compute power, ensuring minimal impact on existing tenants.

### 8. **Implementation Strategy**
   - **Start Small:** Begin with a simple build pipeline using Azure DevOps and gradually incorporate more complex infrastructure management.
   - **Experimentation:** Use the above tools to experiment and refine your approach, ensuring that each step is well-documented for future scalability.

By following this structured approach, you can effectively manage multi-tenant applications on Azure while maintaining security, performance, and observability.
