﻿---
session_code: "BRK139"
title: "Use Azure Migrate for AI assisted insights and cloud transformation"
date: "2025-11-18"
speakers:
  - "Shashank Bansal"
  - "Vishal Jain"
  - "Anant Raigaga"

products:
  - "Microsoft Ignite"

---

# Use Azure Migrate for AI assisted insights and cloud transformation
The migration journey to the cloud using Azure Migrate is a structured process that can be broken down into key steps, each facilitated by specific tools and strategies:

1. **Assessment and Planning**: Begin by assessing the current environment using Azure Migrate. This tool helps in understanding the existing infrastructure and identifying areas for improvement.

2. **Landing Zone Setup**: Define the target environment with appropriate configurations. Use the Azure Migrate agent to suggest network topologies like hub-and-spoke, security measures (e.g., Azure Firewall), and CI/CD tools. Adjustments can be made based on specific requirements, such as switching from GitHub to Azure DevOps.

3. **Wave Definition**: Organize migration steps into waves. Each wave executes a series of tasks, such as database or server migrations, using a combination of automation tools and custom scripts generated by Azure Migrate.

4. **Data Transfer Solutions**: Efficiently handle large datasets with solutions like Azure DataBox for offline transfers and Microsoft Storage Mover for online migrations.

5. **CI/CD Integration**: Implement CI/CD pipelines tailored to the migration process, whether using GitHub Copilot or other tools, ensuring smooth execution of scripts and configurations.

6. **Resiliency and Scalability**: Ensure the target environment is resilient by setting up multiple regions and maintaining high availability and disaster recovery capabilities.

7. **AI Assistance**: Leverage GitHub Copilot for AI-driven assistance in code generation and troubleshooting during migration tasks.

8. **Security Compliance**: Implement security measures as suggested, ensuring compliance with regulatory standards.

9. **Hands-On Practice**: Engage with labs and additional sessions to gain hands-on experience and confidence in the tools and processes involved.

By following these steps and utilizing the mentioned tools, organizations can effectively migrate their applications and data to the cloud, achieving a seamless transition that supports scalability and cost efficiency.
