﻿---
session_code: "BRK150"
title: "From legacy to modern .NET on Azure faster than ever"
date: "2025-11-18"
speakers:
  - "Jon Galloway"
  - "Gaurav Seth"

products:
  - "Microsoft Ignite"

---

# From legacy to modern .NET on Azure faster than ever
**Azure App Service Managed Instances: A Comprehensive Overview**

Azure App Service offers a robust platform for hosting web applications, enabling developers to build, deploy, and manage applications in the cloud. This service supports various app types, including web apps, mobile apps, and API services, making it versatile for different development needs.

**Managed Instances: An Introduction**

Managed instances allow developers to run their applications within containers, offloading the responsibility of managing the underlying OS and infrastructure from their workflow. This is particularly beneficial for applications with complex dependencies or specific OS requirements, as Azure handles the operational aspects.

**Migration and Deployment Process**

Migrating an existing application to Azure App Service involves the use of installation scripts that handle dependencies and configurations. These scripts enable non-containerized apps to leverage Azure's managed environment without significant changes to the codebase.

**Storage Integration**

Applications can seamlessly integrate with external storage solutions like Azure File Storage or Blob Storage, allowing data to be accessed externally while keeping the application logic decoupled from storage management.

**Registry Adapters and Adapter Logs**

Registry adapters facilitate the integration of custom components or scripts into Azure App Service. Adapter logs enhance monitoring and maintenance by providing visibility into these integrations, ensuring both performance and security are maintained.

**Troubleshooting with RDP**

While RDP provides direct access for troubleshooting, it's recommended for quick changes. Persistent configurations should be managed through setup scripts to ensure they survive scale operations or OS updates.

**Scalability and Modernization Tools**

Azure handles scaling automatically across regions, distributing load efficiently without manual intervention. GitHub Copilot aids in modernization by offering containerization guidance and best practices, assisting developers in transitioning their apps to cloud-native formats.

**Considerations and Best Practices**

- **Registry Adapter Functionality:** This integration likely involves custom interfaces or APIs that allow third-party components to interact with the Azure environment.
  
- **RDP Usage:** Best practices include minimizing frequent reconnections and ensuring changes don't disrupt application functionality during scaling.

- **Edge Cases:** Managed instances can handle dependencies through setup scripts, though there may be limitations on specific libraries; thorough testing is advised.

**Conclusion**

Azure App Service's managed instances provide a streamlined approach to cloud development, allowing developers to focus on coding while Azure manages infrastructure. This solution enhances deployment efficiency and reliability, making it an attractive option for various app scenarios.
