﻿---
session_code: "BRK158"
title: "Modernize on-premises VMware environments with Azure VMware Solution"
date: "2025-11-21"
speakers:
  - "Scott Gruenemeier"
  - "Christophe Herrbach"

products:
  - "Microsoft Ignite"

---

# Modernize on-premises VMware environments with Azure VMware Solution
**Answer: Understanding Azure VMware Solution (AVS)**

Azure VMware Solution (AVS) is an innovative approach designed to facilitate the migration of existing VMware environments to Azure with minimal disruption. Here's a structured overview of AVS, its key features, and implications:

1. **Migration Overview**: AVS enables the seamless transition of VMware workloads to Azure without the need for extensive re-architecture, making it an efficient solution for organizations looking to modernize their IT infrastructure.

2. **Private Endpoints and Networking**:
   - **Purpose**: Private endpoints ensure that VMs in Azure have private IPs and are not exposed to the public internet unless necessary.
   - **Implementation**: Utilizes DNS resolution techniques to keep traffic within the virtual network, enhancing security.

3. **HCX with Stretch Networking**:
   - **Functionality**: HCX (VMware Cloud Foundation on Azure) with stretch networking allows for a smooth migration process, especially beneficial for complex workloads and large-scale migrations.
   - **Importance**: This feature is highlighted as a critical component of AVS, contributing significantly to its success.

4. **Cognitive Services Integration**:
   - **Usage**: AI-driven tools can automate tasks such as scaling and load balancing, enhancing operational efficiency post-migration.

5. **Disaster Recovery and High Availability**:
   - **Features**: Utilizes SRM (Storage Replica) for data replication and live migrate for VM migration between regions or within the same region, ensuring continuous availability.

6. **Continuous Modernization**:
   - **Process**: Involves phases like assessment, planning, piloting, and migration. Ongoing optimization is crucial for maintaining performance and efficiency in Azure.

7. **Feedback on Storage Offerings**:
   - **Purpose**: Collecting feedback to enhance storage solutions, focusing on areas like usability, performance, and cost-efficiency, especially relevant for large VM workloads.

8. **Learning Resources**:
   - **Tools**: Interactive tools available at aka.ms/avvs-demos aid in hands-on learning and testing of AVS capabilities.

9. **Challenges and Considerations**:
   - **Complexity**: Migrating large workloads (like a thousand VMs) requires robust tools like HCX, which AVS provides.
   - **Security and Networking**: Detailed understanding of how private DNS resolvers and conditional forwarders operate is essential for secure network setup.

10. **Incentive Program**:
    - **Contest**: A $500 contest on storage feedback encourages engagement from users, offering insights into user priorities and needs.

**Conclusion**: AVS presents a comprehensive solution for VMware migration with advanced features that address security, efficiency, and scalability. For organizations looking to modernize their IT infrastructure while maintaining performance and continuity, AVS is a robust choice.
