﻿---
session_code: "BRK163"
title: "Drive faster insights with Microsoft and SAP AI and data innovations"
date: "2025-11-20"
speakers:
  - "Robert Hernandez"
  - "Nathan Weaver"

products:
  - "Microsoft Ignite"

---

# Drive faster insights with Microsoft and SAP AI and data innovations
**Final Answer:**

In a complex IT landscape involving multiple systems such as SAP, Oracle, and Salesforce, integrating SAP Business Process Services (BPS) alongside SAP Co-pilot provides a comprehensive solution. Here's how they work together:

1. **SAP Co-pilot**: Acts as a virtual assistant that interacts with individual systems using their respective APIs or connectors. It handles tasks specific to each system effectively.

2. **BPS Agent**: Focuses on orchestrating business processes and data integration across various applications, including SAP, Oracle, and Salesforce. It automates workflows and ensures real-time monitoring and data consistency.

3. **Pre-built Data Models**: BPS facilitates the translation of data from SAP into formats compatible with tools like Power BI, bridging gaps between different systems' data structures.

4. **Use Case Scenario**:
   - For a company using multiple ERPs (e.g., SAP, Oracle) and wanting to analyze data in Power BI, BPS helps translate and integrate data.
   - It automates tasks across all systems, providing end-to-end process management without the need for manual intervention in each system.

5. **Integration Strategy**:
   - Co-pilot handles individual system interactions, while BPS manages cross-system orchestration and automation.
   - Pre-built data models from SAP, accessible via Fabric, allow efficient data utilization without moving all data into a single location.

6. **Considerations**:
   - **Licensing and Configuration**: Ensure proper setup for ECC and other systems to enable effective interaction with BPS.
   - **Data Governance and Security**: Implement measures to manage access and maintain data integrity across connected applications.

In summary, using both SAP Co-pilot and BPS enhances integration and process management, particularly beneficial in diverse IT landscapes. This setup ensures efficient automation, analysis, and monitoring, addressing the complexities of multi-system environments.
