﻿---
session_code: "BRK169"
title: "Build secure applications with Azure Policy and Service Groups"
date: "2025-11-19"
speakers:
  - "Jodi Boone"
  - "Kemley Nieva"

products:
  - "Microsoft Ignite"

---

# Build secure applications with Azure Policy and Service Groups
**Microsoft's Governance Strategy: Securing Assets with Resource Graph and Policy Enforcement**

1. **Introduction to Asset Management:**
   - Microsoft emphasizes the importance of securing assets across various levels, including physical infrastructure, virtual machines, operating systems, services, and applications.
   - The use of Resource Graph provides a unified view of these assets, enabling comprehensive management and dependency assessment.

2. **Policy Enforcement for Security:**
   - Policies are implemented to enforce security configurations, ensuring compliance with regulatory standards.
   - Delete policies specifically target managing deletions to prevent unintended impacts on the system.

3. **Safe Deletion Campaigns:**
   - Ensuring safe deletions involves verifying that resources are not in use and have no dependencies before deletion.
   - This is crucial for maintaining system integrity and preventing issues from accidental deletions.

4. **Handling Updates and Security Through Policy:**
   - Microsoft employs "deny delete" policies at various scopes (tenant route, management groups) to control access and changes.
   - Opt-in enforcement allows teams to subscribe to policy application, providing flexibility while maintaining security.

5. **Policy Enrollments for Centralized Enforcement:**
   - A new feature called Policy Enrollments facilitates central enforcement without exemptions, ensuring consistent compliance across teams.

6. **Impact Assessment and Triaging:**
   - Resource Graph and Service Groups provide visibility into resource dependencies, aiding in quick triage of issues and effective management of changes.

7. **Conclusion and Next Steps:**
   - The presentation encourages engagement with additional materials via QR codes and handouts.
   - Focus is on using centralized tools for secure asset management and consistent policy enforcement to maintain system security and prevent costly errors.

**Key Takeaways:**
- Microsoft's approach leverages Resource Graph for comprehensive asset visibility and Service Groups for structured management.
- Centralized policies, including delete controls, enforce compliance and security, preventing system vulnerabilities.
- Opt-in models for policy enforcement offer flexibility while ensuring adherence to security protocols.

This strategy underscores the importance of proactive management and robust policy enforcement in maintaining a secure and reliable infrastructure.
