﻿---
session_code: "BRK170"
title: "Govern your estate using PowerShell and the CLI with AI"
date: "2025-11-21"
speakers:
  - "Steven Bucher"
  - "Damien Caro"

products:
  - "Microsoft Ignite"

---

# Govern your estate using PowerShell and the CLI with AI
The transcript from Microsoft Ignite provides insights into several key areas discussed during the event. Here's a structured breakdown of these topics, along with additional context and significance:

1. **"What If" Module in PowerShell and Dry Run Capability:**
   - **Discussion:** The session covered the development of a new "What If" module designed to provide actionable outcomes based on potential changes without executing them.
   - **Significance:** This feature aims to enhance users' ability to test scenarios, reducing errors by offering predictions before implementation. It's part of an ongoing effort to improve PowerShell's capabilities, especially for administrators managing complex environments.

2. **Deprecated AVM Modules and Migration Strategies:**
   - **Discussion:** The speakers acknowledged the deprecation of certain Azure Virtual Machines (AVM) modules and the challenges faced when users still rely on them due to their historical importance.
   - **Significance:** With Microsoft's focus shifting towards newer tools and practices, users are encouraged to migrate to supported solutions. This includes contributing to open-source projects or rewriting existing code using Terraform or other modern tools.

3. **Installation Requirements for CLI Tools:**
   - **Discussion:** The need for local admin rights when installing Microsoft CLI tools was raised, with an acknowledgment that it's a legacy requirement.
   - **Significance:** While the requirement is currently a historical artifact, efforts are underway to find solutions that allow for local user installations. This could be crucial for organizations seeking to deploy without administrative access restrictions.

4. **Best Practices for Managing Deprecated Modules:**
   - **Discussion:** The session highlighted the importance of reviewing and updating deprecated modules, encouraging community contributions and proactive code migration.
   - **Significance:** As technology evolves, staying updated is vital. Users are urged to engage with Microsoft and contribute to maintain and enhance existing tools.

5. **Integration of "What If" Tool into Main Modules:**
   - **Discussion:** The standalone "What If" tool is planned for integration into the general availability modules once stable.
   - **Significance:** This move underscores Microsoft's commitment to improving user experience and reliability, ensuring that advanced features become more accessible over time.

**Questions and Points for Discussion:**

- **AVM Modules Orphaned:** How can users transition smoothly while maintaining existing infrastructure?
- **Installation Rights:** Are there immediate workarounds or alternative solutions for CLI tool installations without admin access?
- **Module Migration:** What tools or resources does Microsoft provide to assist with migrating from deprecated modules?

**Conclusion:**
The event emphasizes Microsoft's dedication to enhancing their tools and services, encouraging community involvement, and addressing legacy issues. Users are encouraged to engage actively with these developments to leverage the latest features effectively.
