﻿---
session_code: "BRK171"
title: "What’s new and what’s next in Azure IaaS"
date: "2025-11-18"
speakers:
  - "Igal Figlin"
  - "Narayan Annamalai"
  - "Aung Oo"

products:
  - "Microsoft Ignite"

---

# What’s new and what’s next in Azure IaaS
**Summary of Azure Core Innovations: A Comprehensive Overview**

Azure Core is positioned as a robust platform designed to handle high-performance computing tasks, particularly in the realm of AI workloads. Here's an organized summary of its key features and innovations:

1. **Infrastructure for Large AI Models**: Azure Core is engineered to support training models with trillions of parameters, emphasizing the need for scalable and efficient infrastructure.

2. **Data Integration and Storage**:
   - **Azure Blob Storage**: Highlighted for its high performance in handling large datasets, achieving impressive read/write speeds of 51 terabits per second.
   - **Integration with AI Services**: Azure Core integrates seamlessly with services like Azure AI Foundry, facilitating data flow from storage to processing units.

3. **Virtualization Techniques**:
   - **Direct Virtualization**: Optimizes inference performance by running child VMs on a host, reducing overhead and improving GPU utilization, ideal for real-time applications.

4. **Kubernetes for AI Workloads**:
   - **Kubernetes Operator for AI (KAIO)**: Automates model tuning and inference workloads within Kubernetes clusters, enhancing efficiency and scalability.

5. **Autonomous Cloud Operations with Azure Copilot**: Azure Copilot is introduced as a tool for agentic cloud operations, automating tasks based on policies, currently in private preview.

6. **Collaboration with AI Frameworks**:
   - Supports various frameworks, including Microsoft's own tools and third-party options like TensorFlow and PyTorch, offering versatility in implementation strategies.

7. **Partnership with AnyScale**: Collaboration with AnyScale introduces a serverless approach, enhancing scalability by abstracting infrastructure management from developers.

**Considerations and Questions**:
- Real-world applicability and limitations of performance metrics.
- Comparison of virtualization methods (e.g., direct vs. nested) in terms of performance and resource utilization.
- Integration points and case studies to better understand implementation strategies.

In conclusion, Azure Core presents a comprehensive framework for AI workloads, combining robust storage solutions, efficient virtualization, containerization, and Kubernetes-based automation. While impressive, further exploration into real-world applicability and integration is crucial for effective implementation.
