﻿---
session_code: "BRK1736"
title: "Modernize Kubernetes with real-time visibility and control"
date: "2025-11-21"
speakers:
  - "Lachlan Evenson"

products:
  - "Microsoft Ignite"

---

# Modernize Kubernetes with real-time visibility and control
DRSI (Data-Driven Responsive Systems Infrastructure) is a tool that enables real-time monitoring and response by linking database changes to Kubernetes state, allowing for dynamic infrastructure adjustments. Here's a structured summary of its functionality and integration:

### Key Features:
1. **Database-Cluster Integration**: DRSI connects databases like PostgreSQL with Kubernetes clusters, enabling queries on both.
2. **Continuous Queries**: It supports continuous queries that automatically update when database or cluster changes occur.
3. **SignalR for Notifications**: Uses SignalR to notify subscribers of changes in real-time, enabling reactive applications.
4. **VS Code Integration**: Offers a VS Code extension for managing DRSI instances, sources, and querying data.

### Architecture:
- **Sources**: Connects to databases and Kubernetes clusters to pull data for queries.
- **Continuous Queries**: Written in OpenCipher, these queries automatically update when data changes, ensuring real-time insights.
- **SignalR Subscriptions**: Subscribers are notified of query changes, allowing for immediate action or updates in dashboards like Grafana.

### Use Cases:
- **Monitoring High-Risk Images**: Tracks pod images and updates dashboards dynamically.
- **Scalability**: Designed to handle large clusters and complex queries efficiently.
- **Integration with Tools**: Can be integrated with Grafana via plugins, providing unified insights.

### Workflow Examples:
1. **Detecting Risky Images**: Monitors pods for high-risk images and updates dashboards in real-time.
2. **Automated Responses**: Triggers actions based on state changes, such as scaling or reconfiguring pods.

### Considerations:
- **Scalability and Performance**: DRSI's architecture should be optimized for large-scale deployments.
- **Integration Methods**: Utilizes APIs and listeners to interact with Kubernetes and databases.

DRSI offers a powerful way to connect database changes with Kubernetes state, enabling proactive infrastructure management. For deeper insights, exploring its documentation or source code would be beneficial.
