﻿---
session_code: "BRK174"
title: "Running AI on Azure Storage: Fast, secure, and scalable"
date: "2025-11-20"
speakers:
  - "Vamshi Kommineni"
  - "Natalie Mao"
  - "Saurabh Sensharma"

products:
  - "Microsoft Ignite"

---

# Running AI on Azure Storage: Fast, secure, and scalable
**Summary of Learnings from Microsoft Azure Blob Storage Talk**

1. **Storage Hierarchy**: The storage account is the root, containing containers (similar to directories), and blobs (optimized for bulk data operations). Understanding this hierarchy helps in organizing and accessing data efficiently.

2. **Key Features**:
   - **Access Control Lists (ACLs)**: Implement fine-grained permissions for security.
   - **Shared Access Signatures (SAS)**: Provide temporary access without full credentials, useful for data processing workflows.
   - **Blob Versioning**: Supports multiple versions of blobs, aiding in rollbacks and data retention.
   - **Encryption**: Ensures data protection at rest and in transit with built-in encryption options.

3. **Performance Optimization**:
   - **Storage Tiers**: Choose between Hot Access (high throughput), Cool Access (cost-effective for infrequent access), and Archive Access (low cost, slow access).
   - **Data Tiering**: Use lifecycle policies to manage data retention and cost-efficiency.

4. **AI-Powered Insights with Co-pilot**:
   - Utilize AI tools for natural language queries, aiding in quick data analysis without complex coding.

5. **Security Practices**:
   - Monitor and configure settings for anonymous access, shared key access, and error logs to maintain robust security posture.

6. **Best Practices**:
   - Archive infrequently accessed data to save costs.
   - Use Data Lake Gen 2 for unified data management across hot and cold data.
   - Partition blobs for efficient organization and manageability.

7. **Integration with Applications**:
   - Blob Storage supports end-to-end AI/ML pipelines by managing intermediate data and caching frequently accessed datasets.

8. **Governed Access**:
   - Implement SAS for secure access in third-party services, ensuring proper setup of expiration times and scopes.

9. **Cost Management**:
   - Balance cost efficiency with data retention needs, considering trade-offs between Hot Access and Archive Access tiers.

10. **Cloud Migration**:
    - Efficient data management features like versioning and lifecycle policies facilitate cloud migration, addressing challenges in large data transfers.

11. **Future Exploration**:
    - Explore Blob Storage's role in cloud migration strategies and its impact on application architectures, particularly for AI-driven workloads.

In conclusion, Microsoft Azure Blob Storage offers a robust solution for managing unstructured data with features that enhance security, performance, and cost efficiency. Understanding and implementing these features can significantly improve data management practices in various projects.
