﻿---
session_code: "BRK194"
title: "Driving agentic innovation with MCP as the backbone of tool-aware AI"
date: "2025-11-19"
speakers:
  - "Maria Naggaga"
  - "Don Scott"

products:
  - "Microsoft Ignite"

---

# Driving agentic innovation with MCP as the backbone of tool-aware AI
**MCP Protocol: An Overview**

The Multimodal Client Protocol (MCP) is a versatile communication protocol designed to enable interaction between different systems and agents using multiple data modalities. Here's a breakdown of its key aspects:

1. **Multimodality**: MCP supports various data types, including text, images, audio, and video. This allows agents to communicate effectively across different media formats, enhancing the flexibility and applicability of the protocol.

2. **Agents Interaction**: Agents can interact by sending requests in one modality (e.g., text) and receiving responses in another (e.g., image). This capability is crucial for integrating diverse data sources into a unified communication framework.

3. **API Ex Exposure**: MCP allows existing APIs, managed through Azure API Management (APIM), to be exposed as MCP servers with minimal configuration. This simplifies the integration of new services into the MCP ecosystem without significant code changes.

4. **Delegation and Security**: The protocol supports delegated access using tokens, maintaining the security context across API calls. This ensures that permissions are preserved, enhancing security without compromising functionality.

5. **Streaming Capabilities**: MCP supports both HTTP 1.0 and HTTP 2.0, enabling efficient streaming of data. This is particularly useful for applications like video conferencing where continuous data transmission is essential.

6. **Asynchronous and Parallel Processing**: The protocol is under development to support asynchronous calls and parallel processing, allowing agents to handle multiple requests simultaneously. This improves efficiency in high-load scenarios.

7. **Agent-to-Agent Communication**: There's ongoing work to enhance agent interoperability, making it easier for different components to communicate seamlessly using MCP. This fosters a more flexible and robust system architecture.

8. **Multimodality Beyond Text/Video**: While the focus is currently on text and images, MCP's design suggests potential support for other data types, expanding its applicability across various industries.

In summary, MCP is a powerful tool that bridges different systems and data types, offering flexibility and scalability for building intelligent applications where various components can collaborate effectively.
