﻿---
session_code: "BRK201"
title: "AI builder’s guide to agent development in Foundry Agent Service"
date: "2025-11-19"
speakers:
  - "Salman Quazi"
  - "Dan Taylor"
  - "Travis Wilson"

products:
  - "Microsoft Ignite"

---

# AI builder’s guide to agent development in Foundry Agent Service
**Understanding Multi-Agent Workflows in Azure DevOps: A Comprehensive Overview**

**1. Introduction to Multi-Agent Workflows:**
   - **Definition:** Multi-agent workflows in Azure DevOps allow for the orchestration of complex tasks by coordinating various agents, each specializing in different areas such as cloud platforms, ticketing systems, or escalations.
   - **Purpose:** These workflows enable systematic problem-solving by automating steps and involving human intervention when necessary.

**2. Process Overview:**
   - **Initial Reporting:** The process begins with a user reporting an issue, such as a Kubernetes deployment failure.
   - **Ticket Creation:** Upon reporting, the workflow directs the user to a ticketing agent to create a work item for documentation purposes.
   - **Specialized Agent Handling:** Once the ticket is created, the workflow involves a cloud platform agent specializing in Kubernetes issues. This agent likely reviews logs or configuration settings based on predefined documents.
   - **Escalation Process:** If automated steps fail, the user can request escalation to a human agent. The workflow then transitions to an escalations agent that triggers human intervention.
   - **Resolution and Follow-up:** After escalation, the system waits for a response from the human. If unresolved, it may loop or take alternative actions.

**3. Integration with Azure DevOps Tools:**
   - **API Interaction:** Utilizes OpenAPI/GraphQL API to connect with custom endpoints and create work items.
   - **Workflow Authoring:** Workflows can be authored in VS Code, allowing for offline access and management without a web interface.
   - **Checkpointing Mechanisms:** Supports both multi-tenant (separate data storage per organization) and single-tenant (controlled by the organization) storage options.

**4. Considerations and Features:**
   - **Agent Configuration:** Agents may be custom-built or utilize existing bots within Azure DevOps, each handling specific tasks.
   - **User Experience:** Designed for self-service to reduce dependency on constant human intervention.
   - **Latency Concerns:** Potential delays in resolution due to agent responses, especially when involving humans. This trade-off balances thoroughness with efficiency.
   - **Integration Scenarios:** Can be embedded within various Azure DevOps stages (builds, releases) for seamless problem-solving across the development lifecycle.

**5. Monitoring and Tracking:**
   - **Progress Tracking:** Requires tools or dashboards within Azure DevOps to monitor workflow progress, logs, and outcomes.
   - **Audit Trail:** Possibility of maintaining an audit trail for tracking workflow execution and results.

**6. Conclusion:**
   - Multi-agent workflows offer a flexible approach to handling complex problems by breaking them into manageable steps, enhancing productivity and issue resolution efficiency in Azure DevOps environments.
