﻿---
session_code: "BRK218"
title: "Building Sustainable Software with Agentic DevOps on GitHub"
date: "2025-11-21"
speakers:
  - "Martin Woodward"

products:
  - "Microsoft Ignite"

---

# Building Sustainable Software with Agentic DevOps on GitHub
**Action Plan for Codebase Optimization and Sustainability**

1. **Identify Inefficient Areas:**
   - Begin by scanning the codebase for areas where regular expressions are inlined within while loops, as identified in the meeting. These are prime candidates for optimization.

2. **Implement Refactoring:**
   - Refactor the identified inline regex to be compiled outside the loop, significantly reducing runtime overhead and making the code more efficient.

3. **Adopt Continuous Testing and Measurement:**
   - Integrate continuous testing tools that automatically detect inefficiencies, such as repeated regex compilations, allowing for quick issue resolution without manual inspection.

4. **Focus on High-Impact Changes:**
   - Prioritize optimizations in the most frequently used sections of the codebase to maximize visible gains and serve as a model for other changes.

5. **Measure Efficiency Gains:**
   - Implement metrics tracking within testing processes to monitor efficiency improvements over time, allowing for data-driven decision-making and carbon offset calculations.

6. **Promote Sustainability Mindset:**
   - Develop guidelines that include environmental impact assessments as part of feature implementation decisions, encouraging a culture where sustainability is considered at every stage.

7. **Educate and Train the Team:**
   - Organize workshops or bring in experts to educate team members on identifying inefficiencies and optimizing code effectively.

8. **Handle Legacy Code Carefully:**
   - Develop a strategy for refactoring legacy code, ensuring stability by updating parts incrementally and testing each change thoroughly before deployment.

9. **Foster Collaboration:**
   - Encourage collaboration through pair programming and focused code reviews aimed at efficiency, leveraging diverse team perspectives to identify and solve optimization challenges effectively.

By following this structured approach, we can enhance both the efficiency of our codebase and contribute positively towards environmental sustainability, with measurable outcomes that drive future improvements.
