﻿---
session_code: "BRK221"
title: "Connect to and manage any data, anywhere in Microsoft OneLake"
date: "2025-11-19"
speakers:
  - "Dipti Borkar"
  - "Joshua Caplan"
  - "Paul Purvis"
  - "Adi Regev"
  - "Clay Yeaman"

products:
  - "Microsoft Ignite"

---

# Connect to and manage any data, anywhere in Microsoft OneLake
The One Lake Catalog is a comprehensive platform designed for managing and discovering data within a data fabric architecture. It serves as the central hub for various tasks, including data governance, security, and exploration, all while providing seamless integration with tools like Teams and Excel.

**Key Features and Functionality:**

1. **Optimized Data Discovery:**
   - The catalog allows users to browse domains tailored to their business needs, facilitating efficient discovery of relevant data assets.
   - Users can filter items based on criteria such as ownership, endorsement, workspace, or tags, enhancing the precision of their searches.

2. **Detailed Metadata and Lineage Tracking:**
   - Each data item is accompanied by comprehensive metadata, including descriptions, applied tags, ownership details, and workspace location.
   - The lineage tab provides a clear view of data flow from its source to destination, aiding in understanding data provenance and relationships.

3. **Actionable Insights and Automation:**
   - Auto-summary features enable users to quickly assess the importance and relevance of discovered data without switching contexts.
   - The catalog supports direct actions such as sharing, editing, or curating items, with auto-generated insights guiding users on how to proceed.

4. **Robust Governance and Security:**
   - The governance tab offers insights into data ownership and quality, with recommendations for actions like increasing sensitivity labels.
   - The secure tab manages access controls, allowing users to view access lists, adjust role policies, and ensure compliance with security standards.

5. **Integration and Scalability:**
   - The platform is designed to integrate with various data sources, including semantic models and lakehouses, providing a unified approach to data management.
   - Continuous evolution through API enhancements supports deeper querying and improved search functionality, catering to complex organizational needs.

**Unique Differentiators:**

- **Centralized Data Management:** Provides a single source of truth for data discoverability and governance, reducing silos and enhancing collaboration.
- **Seamless Collaboration Tools Integration:** Easy integration with platforms like Teams and Excel offers an accessible interface for both technical and non-technical users.

**Considerations and Benefits:**

- The tool reduces time spent on data management by centralizing processes, ensuring compliance, and providing actionable insights.
- Scalability and ease of integration are key considerations, as is the usability of its user interface, which appears intuitive based on the presentation.

In conclusion, the One Lake Catalog is a versatile solution for managing data within a data fabric architecture, offering significant benefits in efficiency, governance, and security. Its ability to adapt to complex needs and provide a unified approach makes it a valuable asset for organizations looking to streamline their data management practices.
