﻿---
session_code: "BRK228"
title: "Real-time analytics and AI apps with Cosmos DB in Fabric"
date: "2025-11-20"
speakers:
  - "Mark Brown"
  - "Jai Maldonado"

products:
  - "Microsoft Ignite"

---

# Real-time analytics and AI apps with Cosmos DB in Fabric
**Implementing Azure Cosmos DB with Power BI: A Comprehensive Guide**

1. **Accessing Azure Cosmos DB from Power BI**
   - **Prerequisites**: Ensure access to both Power BI workspace and Azure subscription with Cosms DB enabled.
   - **Steps**:
     a. Connect to an existing or new Power BI workspace.
     b. Create a dataset using "Basic" authentication with provided credentials.
     c. Fetch initial data to structure the dataset.

2. **Data Transformation with Power Query**
   - **Data Structure**: Extract fields from JSON documents, calculate aggregates, and group by product ID for analysis.

3. **Building the Power BI Report**
   - **Visualizations**: Use charts like Bar, Box plot, Gauge, and Line charts.
   - **Scheduling**: Enable scheduled refresh for automatic updates.

4. **Testing and Debugging**
   - **Testing Connection**: Verify data fetching with initial queries.
   - **Debugging Queries**: Inspect results and fix authentication issues using Query Editor.

5. **Handling Incremental Updates**
   - Enable real-time capabilities for live insights, noting potential latency.

6. **Security and Governance**
   - Manage permissions and apply data governance policies to sensitive information.

7. **Performance Considerations**
   - Optimize queries and use efficient models to enhance performance.

8. **Best Practices**
   - Structure documents with necessary fields.
   - Use efficient querying and cache strategies.

9. **Monitoring and Maintenance**
   - Continuously monitor performance of both tools and implement backup strategies for data integrity.

10. **Integration and Collaboration**
    - Document processes, permissions, and schedules for clear understanding among teams.

**Conclusion**: By following these steps, you can effectively integrate Azure Cosmos DB with Power BI to create efficient and insightful reports, leveraging real-time updates and optimized data access.
