﻿---
session_code: "BRK235"
title: "Power agentic defense with Microsoft Sentinel"
date: "2025-11-20"
speakers:
  - "Krishna Kumar Parthasarathy"
  - "Reena Pathak"
  - "Evangeline White"
  - "Scott Woodgate"

products:
  - "Microsoft Ignite"

---

# Power agentic defense with Microsoft Sentinel
**Custom Graphs in Microsoft Sentinel: A Step-by-Step Explanation**

**Introduction:**
Microsoft Sentinel's Custom Graph feature empowers organizations to build domain-specific models that visualize and analyze relationships between security entities such as users, devices, identities, and more. This capability enhances the ability to detect connections, access patterns, and potential attack vectors within an organization's unique environment.

**Building a Custom Graph:**

1. **Define Nodes and Edges:**
   - **Nodes:** Represent entities like Users, Devices, Identities.
   - **Edges:** Represent relationships, such as group memberships or access permissions.

2. **Data Source Integration:**
   - Use normalized data from the Microsoft Sentinel Data Lake to build the graph.
   - Example: Map user activities, device accesses, and group memberships.

3. **Graph Blueprint Creation:**
   - Define the structure of your graph using a blueprint.
   - In code (e.g., Python), specify nodes and edges with properties like timestamps or access levels.

4. **Historical Analysis:**
   - Query historical data to analyze past states, aiding in detecting dormant threats or lateral movements over time.

5. **Query and Visualization:**
   - Utilize algorithms like shortest path or centrality to identify key nodes (e.g., highly connected users).
   - Visualize results through tools like VS Code or Jupyter notebooks for deeper insights.

**Delta Park and KQL Integration:**

- Delta Park allows efficient management of data changes over time, ensuring that historical queries are handled efficiently.
- KQL (Kusto Query Language) is used to query the graph, leveraging its structured data format for quick access and analysis.

**Enhancing Security Analytics:**
Custom graphs complement existing analytics tools by offering a more intuitive way to represent complex relationships. This can uncover connections that are not apparent in flat tables, enhancing threat detection and response.

**Implementation Considerations:**

- **Expertise Required:** A understanding of graph theory and security data modeling is beneficial.
- **Tools Needed:** Use VS Code, Jupyter notebooks, and the Microsoft Sentinel extension for development.
- **Integration:** Build upon existing tools and platforms within the Microsoft ecosystem.

**Conclusion:**
Custom graphs in Microsoft Sentinel offer a powerful way to model and analyze security data, providing insights that can't be gleaned from traditional flat tables. By creating tailored models, organizations can enhance their threat detection and response capabilities, making their security posture more robust.
