﻿---
session_code: "BRK261"
title: "Build Secure AI Agents: Microsoft’s Stack, Your Innovation"
date: "2025-11-21"
speakers:
  - "Neta Haiby"
  - "Harmony Mabrey"
  - "Alyssa Ofstein"

products:
  - "Microsoft Ignite"

---

# Build Secure AI Agents: Microsoft’s Stack, Your Innovation
**Security Measures for AI Agents: Key Considerations**

1. **Prompt Injection Detection and Mitigation:**
   - **Mechanism:** AI systems like Foundry use advanced algorithms to detect manipulations in prompts, such as those intended to cause harm or lead the model astray.
   - **Implementation:** Real-time monitoring of input prompts allows for immediate blocking of malicious attempts, alerting security teams to investigate potential threats.

2. **Task Adherence and AI Creativity:**
   - **Balance:** Ensuring AI models adhere to their task without stifling creativity involves robust policy frameworks that validate the model's responses against predefined objectives.
   - **Enforcement:** Techniques like reinforcement learning from human feedback help maintain task focus while allowing for creative problem-solving within defined boundaries.

3. **Data Security and Compliance Monitoring:**
   - **High-Risk Determination:** Criteria for high-risk agents include data sensitivity, access patterns, and system privileges. Tools like purview provide visibility into these aspects.
   - **Mitigation Strategies:** Beyond shutdowns, organizations can implement data encryption, access controls, and regular audits to manage risks without hindering functionality.

4. **Shadow AI and Oversight:**
   - **Oversight Strategies:** Implementing monitoring tools that apply security policies to shadow AI processes ensures accountability without disrupting their operations.
   - **Transparency Tools:** Providing detailed logs and audit trails allows for post-hoc analysis, enhancing trust in AI systems.

5. **Security Usability Balance:**
   - **User Experience:** Designing secure systems with user-friendly interfaces ensures that users can interact effectively without compromising security.
   - **Educational Programs:** Training users on best practices helps maintain a culture of security while promoting effective use of AI tools.

6. **Future-Proofing Strategies:**
   - **Continuous Adaptation:** Regular updates and model retraining keep systems ahead of emerging threats, such as new prompt engineering techniques.
   - **Monitoring Evolution:** Understanding how models evolve in handling prompts and data helps anticipate potential vulnerabilities.

7. **Policy Frameworks:**
   - **Comprehensive Policies:** Establishing clear guidelines for AI use, access, and data handling ensures consistent application of security measures.
   - **Regulatory Compliance:** Adherence to industry standards and regulations is crucial for organizations managing complex AI environments.

**Conclusion:**
Implementing a multi-layered security approach around AI agents involves continuous monitoring, robust threat detection, and adaptive policies. This strategy not only protects against current threats but also prepares systems for future challenges in AI security.
