﻿---
session_code: "BRK308"
title: "Best practices for always-on agents to support critical workloads"
date: "2025-11-21"
speakers:
  - "Shivani Pradhan"

products:
  - "Microsoft Ignite"

---

# Best practices for always-on agents to support critical workloads
**Self-Service Disaster Recovery (SSDR) Overview: Key Insights and Considerations**

**1. Functionality and Architecture:**
- **Disaster Recovery Solution:** SSDR enables businesses to manage their own disaster recovery without IT intervention, replicating data across regions using Azure VM Scale Sets for scalability.

- **Storage Management:** Utilizes 10 GB of primary storage with an asynchronous copy on a secondary site, charging only for the secondary storage used. This model is cost-effective, focusing on storage costs rather than compute resources.

**2. Replication and Latency:**
- Data replication is asynchronous, potentially introducing latency. SSDR likely manages this by balancing replication with performance needs to ensure acceptable recovery times.

**3. Billing and Cost-Efficiency:**
- Pricing model focuses on usage-based storage costs without overage charges for unused capacity. This approach aims to prevent unexpected costs, though detailed billing practices would be important for financial planning.

**4. Alerting and Integration:**
- SSDR integrates with existing alerting systems to notify teams when thresholds are met, automating notifications and reducing manual intervention in IT operations.

**5. Supported Services:**
- Specific applications like 365 Contact Center and Field Service Sales now have tailored configurations within SSDR, catering to varied business needs and enhancing recovery capabilities for these areas.

**6. Ongoing Development:**
- Previews of finance and operations modules indicate ongoing development based on feedback. Users can contact Microsoft for more information or to express interest in specific features.

**7. Cloudflow Support:**
- The integration with Power Automate Cloudflow, after the GA release of Azure storage services, improves scalability and reliability for users relying on automation tools.

**8. Release Timing and Quality Assurance:**
- SSDR targets a December 2025 GA release, with potential delays to ensure quality. This approach reflects a commitment to product integrity and user trust.

**9. Considerations and Questions:**
- **Failover Process:** Automation of failover based on criteria like latency or server health would be essential for seamless recovery.
- **Synchronization During Peaks:** Management of high I/Os during peak times is crucial to avoid performance issues.
- **Monitoring Tools:** Microsoft likely provides dashboards for managing VM Scale Sets, ensuring comprehensive monitoring and health checks.

**10. Conclusion:**
SSDR presents a cost-effective, user-friendly solution for disaster recovery, ideal for businesses seeking reduced IT intervention costs. While it offers significant benefits, further exploration of its technical specifics and integration with existing infrastructure would be valuable for potential adopters.
