﻿---
session_code: "BRK311"
title: "Drive agent adoption with the M365 Copilot and the Agent Store"
date: "2025-11-20"
speakers:
  - "Siffat Hingorani"
  - "Tony Mathew"

products:
  - "Microsoft Ignite"

---

# Drive agent adoption with the M365 Copilot and the Agent Store
**Final Answer: Understanding Microsoft 365 Copilot Agent Store**

The Microsoft 365 Copilot Agent Store is an essential resource for organizations looking to enhance their productivity and integration capabilities within the Microsoft 365 ecosystem. Here's a structured overview:

1. **Purpose and Functionality**:
   - The Agent Store serves as a gateway for discovering and engaging with various agents. These agents can be chatbots, productivity tools, workflows, or other custom solutions.
   - It curates these agents based on an organization's needs, ensuring relevance and utility.

2. **User Experience**:
   - End-users access the store to find agents tailored to their requirements. The user interface likely allows for search and filtering by categories or keywords.

3. **IT Admin Management**:
   - IT administrators manage agents through the Microsoft 365 Admin Center.
   - Key functions include approving agent requests, controlling access, monitoring usage, and enforcing security and compliance standards.
   - Access controls allow admins to restrict sharing or define groups with specific access rights.

4. **Security and Compliance**:
   - Metadata for each agent includes details on APIs, authentication methods, and operational aspects, crucial for compliance and audit purposes.
   - Admins review API connections to ensure they are secure and compliant with company policies.

5. **Governance and Control**:
   - Admins can define which types of agents are permitted, whether from Microsoft, third-party partners, or internal development teams.
   - This governance helps maintain a consistent and secure environment.

6. **Agent Development and Publishing**:
   - Makers use Copallet Studio to create agents, publish them to specific channels (e.g., Microsoft 365 Copilot), and specify scopes for access.
   - Approval from IT admins is required before an agent can be deployed across the organization.

7. **Integration and Workflow**:
   - Agents integrate with existing systems via APIs, allowing seamless communication tools like email or Teams.
   - User engagement metrics help assess agent value and usage patterns.

8. **Adoption and Resources**:
   - The store tracks user interactions, providing insights into adoption rates and usage trends.
   - Microsoft offers resources and sessions for partners and developers to aid in effective agent development and integration.

In summary, the Agent Store is a versatile tool that empowers organizations to extend Microsoft 365 capabilities, offering control, security, and flexibility in managing custom solutions.
